package com.bxm.adsprod.counter.ticket;

import com.aliyun.openservices.ons.api.PropertyKeyConst;
import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.counter.properties.ConsumerConfiguration;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsPropsConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

import java.util.Map;
import java.util.Properties;
import java.util.Set;

/**
 * @author allen
 * @since 1.0.0
 */
@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties({Configuration.class, AlionsPropsConfiguration.class})
public class ConsumerAutoConfiguration {

    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerAutoConfiguration.class);

    private final AlionsPropsConfiguration alionsPropsConfiguration;
    private final ConsumerConfiguration consumer;

    public ConsumerAutoConfiguration(Configuration configuration, AlionsPropsConfiguration alionsPropsConfiguration) {
        this.alionsPropsConfiguration = alionsPropsConfiguration;
        this.consumer = configuration.getConsumer();
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer advertiserCashierConsumer(@Qualifier("remoteAdvertiserCashier") SingleMessageListener messageListener) {
        return createConsumer(consumer.getAdvertiserCashier(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer userLastTicketRecoderConsumer(@Qualifier("userLastTicketRecorder") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketUserLastRecorder(), messageListener);
    }
    
//    @Bean(initMethod = "init")
    @Deprecated
    public ShutdownConsumer ticketClickCounterConsumer(@Qualifier("ticketClickCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketClick(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketDailyClickCounterConsumer(@Qualifier("ticketDailyClickCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketDailyClick(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketDailyViewCounterConsumer(@Qualifier("ticketDailyViewCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketDailyView(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketCpaDailyBudgetCounterConsumer(@Qualifier("ticketForCpaDailyBudgetCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketCpaDailyBudget(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketForCpaHourlyBudgetCounterConsumer(@Qualifier("ticketForCpaHourlyBudgetCounter") SingleMessageListener messasgeListener) {
        return createConsumer(consumer.getTicketCpaHourlyBudget(), messasgeListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketCpcDailyBudgetCounterConsumer(@Qualifier("ticketForCpcDailyBudgetCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketCpcDailyBudget(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketForCpcHourlyBudgetCounterConsumer(@Qualifier("ticketForCpcHourlyBudgetCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketCpcHourlyBudget(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketHourlyViewCounterConsumer(@Qualifier("ticketHourlyViewCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketHourlyView(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketOcpcClickCounterConsumer(@Qualifier("ticketOcpcClickCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketOcpcClick(), messageListener);
    }
//    @Bean(initMethod = "init")
    @Deprecated
    public ShutdownConsumer ticketOcpcClickWindowedCounterConsumer(@Qualifier("ticketOcpcClickWindowedCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketOcpcWindowedClick(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketUserDailyClickCounterConsumer(@Qualifier("ticketUserDailyClickCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketUserDailyClick(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketUserDailyViewCounterConsumer(@Qualifier("ticketUserDailyViewCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketUserDailyView(), messageListener);
    }

//    @Bean(initMethod = "init")
    @Deprecated
    public ShutdownConsumer ticketViewCountConsumer(@Qualifier("ticketViewCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketView(), messageListener);
    }

    @Bean(initMethod = "init")
    public ShutdownConsumer ticketGroupDailyClickCounterConsumer(@Qualifier("ticketGroupDailyClickCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketGroupUserDailyClick(), messageListener);
    }
    @Bean(initMethod = "init")
    public ShutdownConsumer ticketGroupDailyViewCounterConsumer(@Qualifier("ticketGroupDailyViewCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketGroupUserDailyView(), messageListener);
    }
    @Bean(initMethod = "init")
    public ShutdownConsumer ticketGroupWeekClickCounterConsumer(@Qualifier("ticketGroupWeekClickCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketGroupUserWeeklyClick(), messageListener);
    }
    /**
     * 广告组每周曝光统计
     *
     * @author 阿导
     * @time 2018/3/28
     * @CopyRight 杭州微财科技有限公司
     * @param messageListener
     * @return com.bxm.adsprod.counter.ticket.ShutdownConsumer
     */
    @Bean(initMethod = "init")
    public ShutdownConsumer ticketGroupWeekViewCounterConsumer(@Qualifier("ticketGroupWeekViewCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketGroupUserWeeklyView(), messageListener);
    }
   //  素材开始
    @Bean(initMethod = "init")
    public ShutdownConsumer getTicketAssetsView(@Qualifier("ticketAssetsViewCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketAssetsView(), messageListener);
    }
    @Bean(initMethod = "init")
    public ShutdownConsumer getTicketAssetsClick(@Qualifier("ticketAssetsClickCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getTicketAssetsClick(), messageListener);
    }
    //媒体测试曝光统计
    @Bean(initMethod = "init")
    public ShutdownConsumer getPositionTestViewClick(@Qualifier("ticketPositionTestViewCounter") SingleMessageListener messageListener) {
        return createConsumer(consumer.getMediaPositionTestView(), messageListener);
    }
    private ShutdownConsumer createConsumer(String consumerId, SingleMessageListener messageListener) {
        Properties properties = alionsPropsConfiguration.getConfig();

        if (null == properties) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("properties cannot be null");
            }
            return null;
        }
        if (StringUtils.isBlank(consumerId)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("'consumerId' cannot be blank");
            }
            return null;
        }
        Properties newProps = copy(properties);
        newProps.putIfAbsent(PropertyKeyConst.ConsumerId, consumerId);

        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering consumer: {} of topic: {}", consumerId, messageListener.getTopic());
        }
        return new ShutdownConsumer(newProps, messageListener);
    }

    private static Properties copy(Properties orig) {
        if (null == orig) {
            return null;
        }
        Properties newProps = new Properties();
        Set<Map.Entry<Object, Object>> entries = orig.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            newProps.put(entry.getKey(), entry.getValue());
        }
        return newProps;
    }
}
