package com.bxm.adsprod.counter.ticket.cashier;

import com.bxm.adsprod.counter.ticket.cashier.entity.CashKeeper;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @author allen
 * @since 1.0.0
 */
@Deprecated
public class KeeperAdvertiserCashier extends AdvertiserCashier {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    protected void afterConsume(ClickRequest request, Ticket ticket, long inc, long afterInc) {
        CashKeeper keeper = new CashKeeper();
        keeper.setAdvertiser(ticket.getAdvertiser());
        keeper.setPosition(request.getPosition());
        keeper.setSettleType(ticket.getSettleType());
        keeper.setTicketId(ticket.getId());
        keeper.setUid(request.getUid());
        keeper.setInc(inc);
        keeper.setAfter(afterInc);
        keeper.setTime(new Date());
        mongoTemplate.insert(keeper, createCollectionName());
    }

    private String createCollectionName() {
        return "cash_keeper_" + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }
}
