package com.bxm.adsprod.counter.ticket.cashier;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.counter.event.BalanceNotEnoughEvent;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import org.springframework.context.annotation.Configuration;

import java.math.BigInteger;

/**
 * 基于老平台的数据进行广告主余额结算
 *
 * @author allen
 * @since 1.0.0
 */
@Configuration
public class RemoteAdvertiserCashier extends AdvertiserCashier {

    private final EventPark eventPark;

    @Reference(version = "1.0.0")
    private AdvertiserService advertiserService;

    public RemoteAdvertiserCashier(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @Override
    protected void afterConsume(ClickRequest request, Ticket ticket, long inc, long afterInc) {
        // 0. 只有CPC的券和常规券才需要结算
        boolean isNeededSettle = (null != ticket.getType() && ticket.getType() == Ticket.TYPE_NORMAL) && ticket.isCPC();
        if (!isNeededSettle) {
            return;
        }

        BigInteger adid = ticket.getAdvertiser();
        if (null == adid) {
            return;
        }
        Long balance = advertiserService.getAdvertiserBalance(adid);
        if (balance <= 0) {
            // 余额不足
            eventPark.post(new BalanceNotEnoughEvent(this, ticket));
        }
    }
}
