package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsprod.counter.ticket.counter.TicketAssetsViewCounter.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-26 11:17:00
 * @modifier 拉拉
 * @updated 2018-03-26 11:17:00
 */
@Component
public class TicketAssetsClickCounter extends AbstractClickCounter {

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    protected KeyGenerator getKeyGenerator(ClickRequest clickRequest, Ticket ticket) {
        BigInteger assetsId = clickRequest.getAssetsId();
        if (!clickRequest.isValid()) {
            return TicketKeyGenerator.Statistics.getTicketAllAssetsClick(assetsId);
        } else {
            return TicketKeyGenerator.Statistics.getTicketAllAssetsValidClick(assetsId);
        }
    }

    @Override
    protected boolean isIncrementIfNeeded(ClickRequest clickRequest, Ticket ticket) {
        return null != clickRequest.getAssetsId();
    }
}
