package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsprod.counter.ticket.counter.TicketAssetsViewCounter.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-26 11:17:00
 * @modifier 拉拉
 * @updated 2018-03-26 11:17:00
 */
@Component
public class TicketAssetsViewCounter extends AbstractViewCounter{

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    protected KeyGenerator getKeyGenerator(ViewRequest viewRequest, Ticket ticket) {
        return TicketKeyGenerator.Statistics.getTicketAllAssetsView(viewRequest.getAssetsId());
    }

    @Override
    protected boolean isIncrementIfNeeded(ViewRequest request, Ticket ticket) {
        return null != request.getAssetsId();
    }
}
