package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.common.message.AbstractMessageListener;
import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.counter.ticket.counter.entity.TicketWeightBaseData;
import com.bxm.adsprod.counter.ticket.counter.utils.CounterUtils;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.mq.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.math.BigInteger;

/**
 * @author allen
 * @since 1.0.0
 */
@Deprecated
//@Component
@EnableConfigurationProperties(Configuration.class)
public class TicketClickCounter extends AbstractMessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketClickCounter.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Configuration configuration;

    @Override
    public String getTopic() {
        return configuration.getTopic().getClick();
    }

    @Override
    protected void consume(Message message, Object request, Object returning) {
        consume(message, (ClickRequest) request, (Ticket) returning);
    }

    @PostConstruct
    public void init() {
        CounterUtils.createCollectionIfNecess(mongoTemplate, configuration, TicketWeightBaseData.getCollectionName());
    }

    private void consume(Message message, ClickRequest request, Ticket ticket) {
        if (!request.isValid()) {
            BigInteger ticketId = ticket.getId();
            TicketWeightBaseData o = new TicketWeightBaseData();
            o.setPosition(request.getPosition());
            o.setSettleType(ticket.getSettleType());
            o.setModeltype(TicketWeightBaseData.MODELTYPE_CLICK);
            Integer offerPrice = ticket.getOfferPrice();
            o.setModelvalue(null == offerPrice ? ticket.getPrice() : offerPrice);
            o.setTicketid(ticketId);
            o.setTime(ticket.getTime());
            o.setBillid(ticket.getBillid());
            if (null != request.getAssetsId()) {
                o.setAssetsId(request.getAssetsId());
            }
            mongoTemplate.insert(o, TicketWeightBaseData.getCollectionName());
        } else {
            Query query = new Query(Criteria.where("billid").is(request.getBillid()));
            Update update = new Update().set("valid", 1);
            mongoTemplate.updateFirst(query, update, TicketWeightBaseData.getCollectionName());
        }
    }
}
