package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>日点击次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Component
@EnableConfigurationProperties(Configuration.class)
public class TicketDailyClickCounter extends AbstractClickCounter implements HashCounter {

    @Autowired
    private Configuration local;

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        return clickRequest.isValid() ? 0 : DEFAULT_INCREMENT_VALUE;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getClickOfDaily();
    }

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return String.valueOf(ticketId);
    }
}
