package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>日曝光次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Component
public class TicketDailyViewCounter extends AbstractViewCounter implements HashCounter {

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getViewOfDaily();
    }

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return String.valueOf(ticketId);
    }
}
