package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.counter.ticket.counter.utils.CounterUtils;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>CPC 广告券每小时预算统计器</h3>
 * <p>当该广告券的时间段预算不足时，会将该广告券的状态更新为暂停</p>
 * @author allen
 * @since V1.0.0 2017/12/11
 */
@Component
public class TicketForCpcHourlyBudgetCounter extends AbstractClickCounter implements HashCounter {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private EventPark eventPark;
    @Reference(version = "1.0.0")
    private TicketStatisticsService ticketStatisticsService;

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return String.valueOf(ticketId);
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        if (clickRequest.isValid()) {
            return 0;
        }
        Integer offerPrice = ticket.getOfferPrice();
        return (ticket.isCPC() ? (null == offerPrice) ? ticket.getPrice() : offerPrice : 0);
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfHourly();
    }

    @Override
    protected void afterIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        CounterUtils.doBudgetOfHourly(this, ticketStatisticsService, fetcher, eventPark, ticket);
    }

}
