package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigInteger;

/**
 * 广告组频次曝光限制、
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsprod.counter.ticket.counter.TicketGroupViewCounter.java
 * @CopyRright (c) 2018-万物皆导
 * @created 2018-03-27 14:54:00
 */
@Component
public class TicketGroupDailyViewCounter extends AbstractViewCounter implements HashCounter {

    /**
     * 会首先从{@link #getKeyGenerator(Object, Object)}获取，如果返回为<code>null</code> 则使用这个返回存储需要的KeyGenerator实现
     *
     * @param uid
     * @param ticketId
     * @return
     * @see #getKeyGenerator(Object, Object)
     */
    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    /**
     * 返回存储需要的KeyGenerator实现，可以覆盖这个方法。
     *
     * @param viewRequest
     * @param ticket
     * @return
     * @see #getKeyGenerator(String, BigInteger)
     */
    @Override
    protected KeyGenerator getKeyGenerator(ViewRequest viewRequest, Ticket ticket) {
        Long groupId = ticket.getGroupId();
        return TicketKeyGenerator.Statistics.getTicketGroupDailyViewKey(groupId);
    }

    /**
     * 返回HASH数据的键
     *
     * @param uid
     * @param ticketId
     * @return
     */
    @Override
    public String getField(String uid, BigInteger ticketId) {
        return uid;
    }
    /**
     * 返回过期时间，默认为10天
     *
     * @return
     */
    @Override
    protected int getExpireTimeInSeconds() {
        return 24*60*60;
    }

    @Override
    protected boolean isIncrementIfNeeded(ViewRequest clickRequest, Ticket ticket) {
        return null != ticket.getGroupId();
    }

}
