package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>广告券每小时曝光次数统计器</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
@Component
public class TicketHourlyViewCounter extends AbstractViewCounter implements HashCounter {

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return String.valueOf(ticketId);
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getViewOfHourly();
    }

}
