package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.common.message.AbstractMessageListener;
import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.counter.ticket.counter.ocpc.OcpcWindowedBeans;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.OcpcService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.cache.Windowed;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * @author allen
 * @since 1.0.0
 */
@Component
@Deprecated
public class TicketOcpcClickWindowedCounter extends AbstractMessageListener {

    private final static Logger LOGGER = LoggerFactory.getLogger(TicketOcpcClickWindowedCounter.class);

    private final static String PREFIX = KeyBuilder.build("AD", "WINDOWED");
    private final static String PREFIX_CONSUME = KeyBuilder.build(PREFIX, "CONSUME");
    private final static String PREFIX_VCLICK = KeyBuilder.build(PREFIX, "VCLICK");

    private final Configuration configuration;
    private final OcpcWindowedBeans ocpcWindowedBeans;

    @Reference(version = "1.0.0", timeout = 60000)
    private OcpcService ocpcService;

    public TicketOcpcClickWindowedCounter(Configuration configuration, OcpcWindowedBeans ocpcWindowedBeans) {
        this.configuration = configuration;
        this.ocpcWindowedBeans = ocpcWindowedBeans;
    }

    @Override
    protected void consume(Message message, Object request, Object returning) {
        this.consume(message, (ClickRequest) request, (Ticket) returning);
    }

    private void consume(Message message, ClickRequest request, Ticket returning) {
        if (!returning.isOcpc()) {
            return;
        }

        String position = request.getPosition();
        BigInteger ticketId = request.getTicketId();
        boolean valid = request.isValid();
        int offerPrice = NumberUtils.toInt(String.valueOf(returning.getOfferPrice()));

        String pConsume = KeyBuilder.build(PREFIX_CONSUME, position, ticketId);
        String pVclick = KeyBuilder.build(PREFIX_VCLICK, position, ticketId);

        Windowed pConsumeWindowed = ocpcWindowedBeans.getWindowed(pConsume);
        Windowed pVclickWindowed = ocpcWindowedBeans.getWindowed(pVclick);

        if (valid) {
            long start = System.currentTimeMillis();

            pVclickWindowed.execute(1);

            double vclick = pVclickWindowed.get();
            double consume = pConsumeWindowed.get();

            ocpcService.doValidClick(returning, position, (long) consume, (long) vclick);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Process click of valid data {}, {} in {} ms", vclick, consume, (System.currentTimeMillis() - start));
            }

        } else {
            pConsumeWindowed.execute(offerPrice);
        }
    }

    @Override
    public String getTopic() {
        return configuration.getTopic().getClick();
    }
}
