package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.dal.media.PositionTestMapper;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.adsprod.facade.ticket.media.PositionTest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsprod.counter.ticket.counter.TicketAssetsViewCounter.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-04-09 11:17:00
 * @modifier 拉拉
 * @updated 2018-03-26 11:17:00
 */
@Component
public class TicketPositionTestViewCounter extends AbstractViewCounter implements HashCounter {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired
    private PositionTestMapper positionTestMapper;

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return ticketId.toString();
    }

    @Override
    protected KeyGenerator getKeyGenerator(ViewRequest viewRequest, Ticket ticket) {
        return TicketKeyGenerator.Statistics.getPositionIdTestViews(viewRequest.getPosition());
    }

    @Override
    protected boolean isIncrementIfNeeded(ViewRequest request, Ticket ticket) {
        //从缓存里面获取是否是媒体测试
        PositionTest positionTest = fetcher.fetch(TicketKeyGenerator.Media.getPositionTest(request.getPosition()), PositionTest.class);
        if (positionTest != null && positionTest.isEnabled() && useList(positionTest.getTicketIds(), ticket.getId().toString())) {
            return true;
        }
        return false;
    }

    @Override
    protected void afterIncrement(long val, ViewRequest viewRequest, Ticket ticket) {
        super.afterIncrement(val, viewRequest, ticket);
        //从缓存里面获取是否是媒体测试
        PositionTest positionTest = fetcher.fetch(TicketKeyGenerator.Media.getPositionTest(viewRequest.getPosition()), PositionTest.class);
        if (positionTest != null && positionTest.isEnabled() && useList(positionTest.getTicketIds(), ticket.getId().toString())) {
            //如果判断为true,则修改数据库
            if (isUpdate(positionTest.getCount(), viewRequest.getPosition())) {
                positionTestMapper.updatePositionTest(new Date(), viewRequest.getPosition());
            }
        }


    }

    public Boolean isUpdate(Long count, String positionid) {
        Boolean status = true;
        //判断曝光总数和测试量级比较
        Map<String, Long> map = fetcher.hfetchall(TicketKeyGenerator.Statistics.getPositionIdTestViews(positionid), Long.class);
        for (Long viewCount : map.values()) {
            if (viewCount < count) {
                return false;
            }
        }
        return status;
    }


    static boolean useList(List<BigInteger> arr, String targetValue) {
        return Arrays.asList(arr).contains(targetValue);
    }

}
