package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>广告券用户每天点击次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Component
public class TicketUserDailyClickCounter extends AbstractClickCounter implements HashCounter {

    @Override
    protected int getExpireTimeInSeconds() {
        return TypeHelper.castToInt(DateHelper.getRemainSecondsOfToday());
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        return clickRequest.isValid() ? 0 : DEFAULT_INCREMENT_VALUE;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getClickOfDaily(ticketId);
    }

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return uid;
    }
}
