package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.common.message.AbstractMessageListener;
import com.bxm.adsprod.common.utils.NamedThreadFactory;
import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.counter.ticket.counter.entity.TicketWeightBaseData;
import com.bxm.adsprod.counter.ticket.counter.utils.CounterUtils;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.mq.Message;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.*;

/**
 * @author allen
 * @since 1.0.0
 */
@Deprecated
//@Component
@EnableConfigurationProperties(Configuration.class)
public class TicketViewCounter extends AbstractMessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketViewCounter.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Configuration configuration;

    private static final int SHUTDOWN_WAIT_TIME_OUT_SECOND = 10;
    private volatile int copyTimes = 0;
    private List<TicketWeightBaseData> bucket1 = Collections.synchronizedList(Lists.newArrayList());
    private List<TicketWeightBaseData> bucket2 = Collections.synchronizedList(Lists.newArrayList());
    private ScheduledExecutorService scheduled = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("scheduled"));

    @Override
    protected void consume(Message message, Object request, Object returning) {
        consume(message, (ViewRequest) request, (Ticket) returning);
    }

    @PostConstruct
    public void init() {
        CounterUtils.createCollectionIfNecess(mongoTemplate, configuration, TicketWeightBaseData.getCollectionName());

        scheduled.scheduleWithFixedDelay(new Runnable() {
            @Override
            public synchronized void run() {
                copyTimes++;
                long start = System.currentTimeMillis();
                List<TicketWeightBaseData> tmp = isEvenTimes() ? bucket1 : bucket2;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("copy times: {}, Bucket data size: {}", copyTimes, tmp.size());
                }
                if (CollectionUtils.isNotEmpty(tmp)) {
                    mongoTemplate.insert(tmp, TicketWeightBaseData.getCollectionName());
                }
                tmp.clear();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Process finished in {} ms", (System.currentTimeMillis() - start));
                }
            }
        }, 1000, 5000, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void destroy() {
        scheduled.shutdown();
        try {
            if (!scheduled.awaitTermination(SHUTDOWN_WAIT_TIME_OUT_SECOND, TimeUnit.SECONDS)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Wait for the thread pool execution finish has been time out!");
                }
            }
        } catch (InterruptedException e) {
            scheduled.shutdownNow();
        }
    }

    private void consume(Message message, ViewRequest request, Ticket ticket) {
        BigInteger ticketId = ticket.getId();

        TicketWeightBaseData o = new TicketWeightBaseData();
        o.setPosition(request.getPosition());
        o.setSettleType(ticket.getSettleType());
        o.setModeltype(TicketWeightBaseData.MODELTYPE_VIEW);
        o.setModelvalue(1);
        o.setTicketid(ticketId);
        o.setTime(ticket.getTime());
        if (null != request.getAssetsId()) {
            o.setAssetsId(request.getAssetsId());
        }

        // mongoTemplate.insert(o, TicketWeightBaseData.getCollectionName());

        if (isEvenTimes()) {
            bucket2.add(o);
        } else {
            bucket1.add(o);
        }
    }

    private boolean isEvenTimes() {
        return copyTimes % 2 == 0;
    }

    @Override
    public String getTopic() {
        return configuration.getTopic().getView();
    }

}
