package com.bxm.adsprod.counter.ticket.counter.ocpc;

import com.bxm.warcar.cache.Windowed;
import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.cache.impls.redis.JedisWindowed;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @since 1.0.0
 */
@Deprecated
@Configuration
@EnableConfigurationProperties(JedisConfiguration.class)
public class OcpcWindowedBeans implements DisposableBean {

    private final static Logger LOGGER = LoggerFactory.getLogger(OcpcWindowedBeans.class);
    private final ConcurrentHashMap<String, Windowed> windoweds = new ConcurrentHashMap<String, Windowed>(20000);

    private final ScheduledExecutorService scheduled = new ScheduledThreadPoolExecutor(1,
                new NamedThreadFactory("check"));
    private final JedisPool jedisPool;

    @Autowired
    public OcpcWindowedBeans(JedisConfiguration configuration) {
        this.jedisPool = new JedisPool(configuration, configuration.getHost(), configuration.getPort(),
                configuration.getTimeout(), configuration.getPassword(), 3);

        scheduled.scheduleWithFixedDelay(this::checkSize, 5, 5, TimeUnit.SECONDS);
    }

    @Override
    public void destroy() throws Exception {
        scheduled.shutdownNow();
    }

    public Windowed getWindowed(String primary) {
        if (!windoweds.containsKey(primary)) {
            JedisWindowed windowed = new JedisWindowed(jedisPool, primary, JedisWindowed.Duration.hours(24), JedisWindowed.Duration.minutes(5));
            windoweds.put(primary, windowed);
        }
        return windoweds.get(primary);
    }

    private void checkSize() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("WindowedPoolSize: {}", windoweds.size());
        }
    }

    public JedisPool getJedisPool() {
        return jedisPool;
    }
}
