/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.event.listeners;

import com.bxm.adsprod.counter.event.BalanceNotEnoughEvent;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.eventbus.Subscribe;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BalanceNotEnoughEventListener
implements EventListener<BalanceNotEnoughEvent>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(BalanceNotEnoughEventListener.class);
    @Autowired
    private TicketService ticketService;
    @Autowired
    private AdvertiserService advertiserService;
    private final ScheduledExecutorService recover = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("recover"));
    private final ConcurrentHashMap<BigInteger, Object> advsWithPause = new ConcurrentHashMap();

    public void afterPropertiesSet() throws Exception {
        this.recover.scheduleWithFixedDelay(() -> {
            if (MapUtils.isNotEmpty(this.advsWithPause)) {
                long start = System.currentTimeMillis();
                for (BigInteger id : this.advsWithPause.keySet()) {
                    Long balance = this.advertiserService.getAdvertiserBalance(id);
                    if (null == balance || balance <= 0L) continue;
                    this.advertiserService.incrementBalance(id, Long.valueOf(0L));
                    this.advsWithPause.remove(id);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Finished recover advertiser's ticket in {} ms", (Object)(System.currentTimeMillis() - start));
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    @Subscribe
    public void consume(BalanceNotEnoughEvent event) {
        Ticket ticket = event.getTicket();
        BigInteger advertiser = ticket.getAdvertiser();
        List allTickets = this.ticketService.getAllTickets();
        for (Ticket e : allTickets) {
            BigInteger id;
            Ticket t;
            Long balance;
            boolean isSameAdvertiser = null != e.getAdvertiser() && e.getAdvertiser().equals(advertiser);
            boolean isCpc = e.isCPC();
            if (!isSameAdvertiser || !isCpc || !e.isAvailableForStatus() || null == (balance = this.advertiserService.getAdvertiserBalance(advertiser)) || balance > 0L || (t = this.ticketService.get(id = e.getId())).getStatus() == 3) continue;
            boolean flag = this.ticketService.updateTicketStatus(id, (byte)2, 2);
            if (flag) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6682\u505c-\u4f59\u989d\u4e0d\u8db3)\u66f4\u65b0\u5b8c\u6210", (Object)id);
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6682\u505c-\u4f59\u989d\u4e0d\u8db3)\u66f4\u65b0\u5931\u8d25!", (Object)id);
            }
            this.advsWithPause.put(id, new Object());
        }
    }
}

