/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.event.listeners;

import com.bxm.adsprod.counter.event.BudgetNotEnoughOfDailyEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.google.common.eventbus.Subscribe;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BudgetNotEnoughOfDailyEventListener
implements EventListener<BudgetNotEnoughOfDailyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BudgetNotEnoughOfDailyEventListener.class);
    @Autowired
    private TicketService ticketService;

    @Subscribe
    public void consume(BudgetNotEnoughOfDailyEvent event) {
        Ticket ticket = this.ticketService.get(event.getTicket().getId());
        if (3 == ticket.getStatus()) {
            return;
        }
        if (!ticket.isAvailableForStatus()) {
            return;
        }
        BigInteger id = ticket.getId();
        boolean flag = this.ticketService.updateTicketStatus(id, (byte)2, 1);
        if (flag) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6682\u505c-\u65e5\u9884\u7b97\u4e0d\u8db3)\u66f4\u65b0\u5b8c\u6210", (Object)id);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6682\u505c-\u65e5\u9884\u7b97\u4e0d\u8db3)\u66f4\u65b0\u5931\u8d25!", (Object)id);
        }
    }
}

