/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.event.listeners;

import com.bxm.adsprod.counter.event.BudgetNotEnoughOfHourlyEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.google.common.eventbus.Subscribe;
import java.math.BigInteger;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BudgetNotEnoughOfHourlyEventListener
implements EventListener<BudgetNotEnoughOfHourlyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BudgetNotEnoughOfHourlyEventListener.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private TicketService ticketService;

    @Subscribe
    public void consume(BudgetNotEnoughOfHourlyEvent event) {
        boolean flag;
        Ticket ticket = this.ticketService.get(event.getTicket().getId());
        if (3 == ticket.getStatus()) {
            return;
        }
        if (!ticket.isAvailableForStatus()) {
            return;
        }
        BigInteger id = ticket.getId();
        boolean semaphore = event.isSemaphore();
        if (semaphore) {
            this.setSemaphore(id, event.getTrigger(), event.getSegmentStart(), event.getSegmentEnd());
        }
        if (flag = this.ticketService.updateTicketStatus(id, (byte)2, 5)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6682\u505c-\u65f6\u95f4\u6bb5\u9884\u7b97\u4e0d\u8db3)\u66f4\u65b0\u5b8c\u6210", (Object)id);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6682\u505c-\u65f6\u95f4\u6bb5\u9884\u7b97\u4e0d\u8db3)\u66f4\u65b0\u5931\u8d25!", (Object)id);
        }
    }

    private void setSemaphore(BigInteger id, int trigger, int segmentStart, int segmentEnd) {
        long expire = BudgetNotEnoughOfHourlyEventListener.getRemainSecondsOfHour(segmentEnd - trigger) - 1L;
        if (expire <= 0L) {
            return;
        }
        String value = StringUtils.join((Object[])new Object[]{trigger, segmentStart, segmentEnd}, (char)'-');
        this.updater.update(TicketKeyGenerator.Temp.getTimelineOutOfBudget((BigInteger)id), (Object)value, (int)expire);
    }

    private static long getRemainSecondsOfHour(int hour) {
        return (long)(3600 * hour) - DateUtils.getFragmentInSeconds((Calendar)Calendar.getInstance(), (int)11);
    }
}

