/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.event.listeners;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.facade.advertiser.AdvertiserConstant;
import com.bxm.adsprod.facade.advertiser.StationUserWeightPushParam;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.integration.adsmanager.AdsmanagerService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class StationUserWeightTicketConsumeListener
implements EventListener<TicketClickEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StationUserWeightTicketConsumeListener.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisCounter")
    protected Counter counter;
    @Autowired
    private AdsmanagerService adsmanagerService;
    @Autowired
    private MessageSender messageSender;

    @Subscribe
    public void consume(TicketClickEvent ticketClickEvent) {
        ClickRequest clickRequest = ticketClickEvent.getRequest();
        Ticket ticket = ticketClickEvent.getTicket();
        if (!ticket.isCPC()) {
            return;
        }
        String advertiserId = ticket.getAdvertiser().toString();
        String stationUserWeightListJsonStr = (String)this.fetcher.hfetch(TicketKeyGenerator.Advertiser.getStationUserWeight(), advertiserId, String.class);
        if (StringUtils.isBlank((CharSequence)stationUserWeightListJsonStr)) {
            return;
        }
        List stationUserWeightPushParams = JSONArray.parseArray((String)stationUserWeightListJsonStr, StationUserWeightPushParam.class);
        if (CollectionUtils.isEmpty((Collection)stationUserWeightPushParams)) {
            return;
        }
        Integer offerPrice = ticket.getOfferPrice();
        Integer incrementValue = ticket.isCPC() ? (null == offerPrice ? ticket.getPrice() : offerPrice) : 0;
        String ticketIdStrRegex = "," + ticket.getId().toString() + ",";
        String positionIdStrRegex = "," + clickRequest.getPosition() + ",";
        boolean needUpdateFlag = false;
        ArrayList updateEntities = Lists.newArrayList();
        Long completeWeightId = null;
        for (StationUserWeightPushParam weightPushParam : stationUserWeightPushParams) {
            Long consume;
            updateEntities.add(weightPushParam);
            if (!AdvertiserConstant.StationUserWeight.STATION_USER_WEIGHT_STATUS_NORMAL.equals(weightPushParam.getStatus()) || !weightPushParam.getTicketIdsStr().contains(ticketIdStrRegex) || weightPushParam.getLimitPositionFlag().booleanValue() && !weightPushParam.getPositionIdsStr().contains(positionIdStrRegex) || (consume = this.counter.hincrementByAndGet(TicketKeyGenerator.Advertiser.getConsumeForStationUserWeight(), weightPushParam.getStationUserWeightId().toString(), (long)incrementValue.intValue())).compareTo(weightPushParam.getWeightPlanConsume().longValue()) < 0) continue;
            updateEntities.remove(updateEntities.size() - 1);
            completeWeightId = weightPushParam.getStationUserWeightId();
            needUpdateFlag = true;
        }
        if (needUpdateFlag) {
            this.updater.hupdate(TicketKeyGenerator.Advertiser.getStationUserWeight(), advertiserId, (Object)JSON.toJSONString((Object)updateEntities));
        }
        if (null != completeWeightId) {
            this.noticeAdsmanagerComplete(completeWeightId);
        }
    }

    private void noticeAdsmanagerComplete(Long stationUserWeightId) {
        boolean successFlag = false;
        try {
            LOGGER.info("\u63a8\u9001 \u7ad9\u5185\u6237\u6743\u91cd\u8ba1\u5212\u5b8c\u6210\u5f97ID\u5230\u8fd0\u8425\u540e\u53f0\uff1a{}", (Object)stationUserWeightId);
            successFlag = this.adsmanagerService.stationUserWeightComplete(stationUserWeightId);
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u5931\u8d25\uff01", (Throwable)e);
        }
        if (!successFlag) {
            this.messageSender.send2(new Message("\u6743\u91cd\u8ba1\u5212\u5df2\u5b8c\u6210\uff0c \u4f46\u662f\u63a8\u9001\u5230\u8fd0\u8425\u540e\u53f0\u5931\u8d25\u4e86\uff01\u6743\u91cdid\uff1a" + stationUserWeightId));
        }
    }
}

