/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import java.math.BigInteger;
import org.springframework.stereotype.Component;

@Component
public class TicketAssetsClickCounter
extends AbstractClickCounter
implements HashCounter {
    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    protected KeyGenerator getKeyGenerator(ClickRequest clickRequest, Ticket ticket) {
        if (!clickRequest.isValid()) {
            return TicketKeyGenerator.Statistics.getTicketAllAssetsClick((String)clickRequest.getPosition());
        }
        return TicketKeyGenerator.Statistics.getTicketDailyAssetsValidClick();
    }

    @Override
    protected boolean isIncrementIfNeeded(ClickRequest clickRequest, Ticket ticket) {
        return null != clickRequest.getAssetsId();
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest clickRequest = this.convertRequest(request);
        return clickRequest.getAssetsId().toString();
    }

    @Override
    protected void afterIncrement(long val, ClickRequest request, Ticket ticket) {
        if (!request.isValid()) {
            BigInteger assetsId = request.getAssetsId();
            if (null == assetsId) {
                return;
            }
            this.counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getTicketDailyAssetsClick(), assetsId.toString(), 1L, this.getExpireTimeInSeconds());
        }
    }
}

