/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.BudgetNotEnoughOfDailyEvent;
import com.bxm.adsprod.counter.event.TicketCostExceedCostWarnEvent;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.media.PositionGroupService;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.KeyBuilder;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.EventObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketForCpcDailyBudgetCounter
extends AbstractClickCounter
implements HashCounter {
    @Autowired
    private EventPark eventPark;
    @Autowired
    private PositionGroupService positionGroupService;
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest click = this.convertRequest(request);
        return String.valueOf(click.getTicketId());
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        if (clickRequest.isValid()) {
            return 0L;
        }
        Integer offerPrice = ticket.getOfferPrice();
        return ticket.isCPC() ? (null == offerPrice ? ticket.getPrice() : offerPrice) : 0;
    }

    @Override
    protected void beforeIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        String position = clickRequest.getPosition();
        BigInteger ticketId = ticket.getId();
        this.positionGroupService.incrementIfNecessary(ticketId, position, val);
    }

    @Override
    protected void afterIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        if (val >= (long)ticket.getBudgetDaily().intValue()) {
            this.eventPark.post((EventObject)new BudgetNotEnoughOfDailyEvent(this, ticket));
        }
        try {
            String result = (String)this.fetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARN"}), ticket.getId() + "", String.class);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                Double cosWarn = Double.valueOf(result);
                String cosWarnMark = (String)this.fetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNMARK"}), ticket.getId() + "", String.class);
                if (StringUtils.isNotBlank((CharSequence)cosWarnMark)) {
                    Double cosWarnMarkNew = Double.valueOf(cosWarnMark);
                    if ((double)val >= cosWarnMarkNew) {
                        Double costRdis = (Double)this.fetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSREDIS"}), ticket.getId() + "", Double.class);
                        this.eventPark.post((EventObject)new TicketCostExceedCostWarnEvent(this, ticket, val, costRdis));
                        this.updater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNMARK"}), ticket.getId() + "", (Object)((double)val + cosWarn));
                        this.updater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSREDIS"}), ticket.getId() + "", (Object)val);
                    }
                } else {
                    LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                    long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
                    this.updater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSWARNMARK"}), ticket.getId() + "", (Object)cosWarn, (int)seconds);
                    this.updater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "COSREDIS"}), ticket.getId() + "", (Object)0, (int)seconds);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5238\u6d88\u8017\u63d0\u9192\u8bb0\u5f55\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfDaily();
    }
}

