/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.OcpcService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.ocpc.OcpcRequest;
import com.bxm.warcar.integration.message.AbstractMessageListener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.autoconfigure.Subscriber;
import com.bxm.warcar.mq.autoconfigure.SubscriberWrapper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcloud.sdk.counter.CounterSdk;
import com.bxm.warcloud.sdk.counter.CounterSdkFactory;
import java.math.BigInteger;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Subscriber
public class TicketOcpcClickWarcloudCounter
extends AbstractMessageListener
implements SubscriberWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketOcpcClickWarcloudCounter.class);
    private final Configuration configuration;
    private final CounterSdk sdk;
    @Autowired
    private OcpcService ocpcService;

    public TicketOcpcClickWarcloudCounter(Configuration configuration) {
        this.configuration = configuration;
        this.sdk = CounterSdkFactory.create().url(configuration.getOcpc().getUrlOfWarcloud()).build();
    }

    protected void consume(Message message, Object request, Object returning) {
        this.consume(message, (ClickRequest)request, (Ticket)returning);
    }

    private void consume(Message message, ClickRequest request, Ticket returning) {
        if (!returning.isOcpc()) {
            return;
        }
        String position = request.getPosition();
        BigInteger ticketId = request.getTicketId();
        boolean valid = request.isValid();
        double offerPrice = NumberUtils.toDouble((String)String.valueOf(returning.getOfferPrice()));
        String keyConsume = KeyBuilder.build((Object[])new Object[]{"C", position, ticketId});
        String keyValidClick = KeyBuilder.build((Object[])new Object[]{"V", position, ticketId});
        if (valid) {
            long begin = System.currentTimeMillis();
            this.sdk.incr(keyValidClick, 1.0);
            long consume = this.getSdkValue(keyConsume);
            long validClick = this.getSdkValue(keyValidClick);
            if (consume > 0L && validClick > 0L) {
                this.ocpcService.doValidClick(new OcpcRequest(returning, position, Long.valueOf(consume), Long.valueOf(validClick)));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Process [{}/{}] click of valid data {}, {} in {} ms", new Object[]{position, ticketId, validClick, consume, System.currentTimeMillis() - begin});
            }
        } else {
            this.sdk.incr(keyConsume, offerPrice);
        }
    }

    private long getSdkValue(String key) {
        try {
            double v = this.sdk.get(key);
            return TypeHelper.castToLong((Object)v);
        }
        catch (Exception e) {
            LOGGER.error("get: ", (Throwable)e);
            return 0L;
        }
    }

    public String getTopic() {
        return this.configuration.getTopic().getClick();
    }

    public String getConsumerId() {
        return this.configuration.getConsumer().getTicketOcpcWarcloudClick();
    }
}

