/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.dal.media.PositionTestMapper;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.media.PositionTest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketPositionTestClickCounter
extends AbstractClickCounter
implements HashCounter {
    private static final Logger logger = LoggerFactory.getLogger(TicketPositionTestClickCounter.class);
    private static final Short STATUS_TWO = 2;
    private static final Short STATUS_THREE = 3;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private PositionTestMapper positionTestMapper;

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    protected KeyGenerator getKeyGenerator(ClickRequest clickRequest, Ticket ticket) {
        return TicketKeyGenerator.Statistics.getPositionIdTestClick((String)clickRequest.getPosition());
    }

    @Override
    protected boolean isIncrementIfNeeded(ClickRequest clickRequest, Ticket ticket) {
        PositionTest positionTest = (PositionTest)this.fetcher.fetch(TicketKeyGenerator.Media.getPositionTest((String)clickRequest.getPosition()), PositionTest.class);
        if (positionTest != null && positionTest.isEnabled() && positionTest.getTicketIds().contains(new BigInteger(ticket.getId().toString())) && TicketPositionTestClickCounter.after(new Date(), positionTest.getStartTime())) {
            if (positionTest.getState() == STATUS_THREE) {
                return false;
            }
            return this.isNeed(ticket.getId().toString(), clickRequest.getPosition(), positionTest);
        }
        return false;
    }

    public Boolean isNeed(String ticketId, String positionId, PositionTest positionTest) {
        Map ocpcMap = this.fetcher.hfetchall(TicketKeyGenerator.getAllTickets(), Ticket.class);
        if (((Ticket)ocpcMap.get(ticketId)).getCloseThreshold() == null) {
            return false;
        }
        Map clickMap = this.fetcher.hfetchall(TicketKeyGenerator.Statistics.getPositionIdTestClick((String)positionId), Long.class);
        if (clickMap == null || clickMap.get(ticketId) == null || clickMap.get(ticketId) != null && (Long)clickMap.get(ticketId) < (long)((Ticket)ocpcMap.get(ticketId)).getCloseThreshold().intValue()) {
            return true;
        }
        if (this.isUpdate(ocpcMap, clickMap).booleanValue() && clickMap.size() == positionTest.getTicketId().split(",").length) {
            this.positionTestMapper.updatePositionTest(new Date(), positionId);
            positionTest.setState(STATUS_TWO);
            this.updater.update(TicketKeyGenerator.Media.getPositionTest((String)positionId), (Object)positionTest);
        }
        return false;
    }

    public Boolean isUpdate(Map<String, Ticket> ocpcMap, Map<String, Long> clickMap) {
        for (String ticketId : clickMap.keySet()) {
            if (clickMap.get(ticketId) >= (long)ocpcMap.get(ticketId).getCloseThreshold().intValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest click = this.convertRequest(request);
        return String.valueOf(click.getTicketId());
    }

    public static boolean after(Date date1, Date date2) {
        long date1Long = date1.getTime();
        long date2Long = date2.getTime();
        return TicketPositionTestClickCounter.after(date1Long, date2Long);
    }

    public static boolean after(long data1, long data2) {
        return data1 - data2 > 0L;
    }
}

