package com.bxm.adsprod.dal.activity;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.bxm.adsprod.model.dto.ActivityPositionRelationDto;
import com.bxm.adsprod.model.dto.ActivityPositonWeightDto;

/**
 * @author allen
 * @since V1.0.0 2018/01/04
 */
@Mapper
public interface ActivityMapper {

    /**
     * 查询所有在使用的默认活动
     * @return
     */
    List<ActivityPositonWeightDto> selectDefaultAct(@Param("nowDate") Date nowDate);
    
    /**  
     * @Title: selectPostionAct  
     * @Description:  获取广告位关联活动配置信息
     * @author xavier  
     * @date 2018年5月13日
     */  
    List<ActivityPositionRelationDto> selectPostionAct(@Param("nowDate") Date nowDate);

    /**
     * @Title: selectPostionAct
     * @Description:  获取广告位关联活动配置信息
     * @author bcc
     */
    List<ActivityPositionRelationDto> selectPostionActByPositionId(@Param("nowDate") Date nowDate,@Param("positionId")String positionId);
}
