package com.bxm.adsprod.dal.income.ext;

import com.bxm.adsprod.model.dao.income.AdTicketIncome;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 查询收益mapper
 *
 * @ClassName AdTicketIncomeMapperExt
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/5/14 17:25
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/5/14 17:25
 **/
public interface AdTicketIncomeMapperExt {
	/**
	 * 查询最近有消耗的第一天
	 *
	 * @param ticketIds
	 * @return com.bxm.adsprod.model.dao.income.AdTicketIncome
	 * @throws
	 * @author kk.xie
	 * @date 2018/5/15 10:42
	 */
	List<AdTicketIncome> findIncomeOfMaxFirstDatetime(@Param("ticketIds") List<Long> ticketIds);

	/**
	 * 查询最近有消耗的第二天
	 *
	 * @param ticketIds
	 * @return java.util.List<com.bxm.adsprod.model.dao.income.AdTicketIncome>
	 * @throws
	 * @author kk.xie
	 * @date 2018/5/16 10:51
	 */
	List<AdTicketIncome> findIncomeOfMaxSecondDatetime(@Param("ticketIds") List<Long> ticketIds);
}
