package com.bxm.adsprod.facade.commons;

import java.util.Map;

/**
 * <h3>推送服务</h3>
 *
 * <p>将数据推送到<code>serviceName</code>服务，对应的服务接收到请求后，会根据<code>parameters</code>参数约定来生成缓存的KEY，最后将<code>data</code>数据更新到缓存中。</p>
 * @author allen
 * @date 2017-12-04
 */
public interface CachePushableService {

    /**
     * 推送数据到缓存。
     *
     * @param serviceName 服务名
     * @param parameters 参数列表
     * @param data 数据
     * @return 推送反馈描述信息
     * @see com.bxm.warcar.cache.push.Pushable
     * @see CachePushableFields
     * @throws CachePushException
     * @deprecated 建议使用 {@link #push(CachePushableEntity)}
     */
    @Deprecated
    String push(String serviceName, Map<String, Object> parameters, byte[] data) throws CachePushException;

    /**
     * 推送数据到缓存
     * @param entity 数据内容体
     * @return 推送反馈描述信息。
     */
    String push(CachePushableEntity entity) throws CachePushException;
}
