package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.ticket.assets.TicketAssetsStatistics;

import java.math.BigInteger;
import java.util.List;

/**
 * @author allen
 * @since 1.0.0
 */
public interface TicketAssetsService {

    /**
     * 返回指定广告券的素材信息
     *
     * @param ticketId
     * @return
     */
    List<TicketAssets> get(BigInteger ticketId);

    /**
     * 根据素材id获取所有素材的点击
     *
     * @param assetsId
     * @return
     */
    long getAllClicks(BigInteger assetsId);

    /**
     * 根据素材id获取所有素材的曝光
     *
     * @param assetsId
     * @return
     */
    long getAllViews(BigInteger assetsId);

    /**
     * 根据素材id获取所有素材的有效点击
     *
     * @param assetsId
     * @return
     */
    long getAllValidClicks(BigInteger assetsId);

    /**
     * 素材最近2小时统计数据
     *
     * @param assetsId
     * @return
     */
    @Deprecated
    String[] getTicketAssets2Hour(BigInteger assetsId);

    /**
     * 素材最近24小时统计数据
     *
     * @param assetsId
     * @return
     */
    @Deprecated
    String[] getTicketAssets24Hour(BigInteger assetsId);

    /**
     * 返回指定广告券的素材信息
     *
     * @param assetsId
     * @return
     */
    TicketAssets getTicketAssets(BigInteger ticketId, BigInteger assetsId);

    /**
     * 返回素材最近<code>hours</code>小时的统计数据。如果<code>hours</code>等于-1，那么取所有时间的累计数据。
     * @param assetsId
     * @param hours
     * @return
     */
    TicketAssetsStatistics getOfHours(BigInteger assetsId, int hours);
}
