package com.bxm.adsprod.facade.ticket;

import java.math.BigInteger;

/**
 * <h3>广告券统计服务</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/06
 */
public interface TicketStatisticsService {

    /**
     * 返回广告券今日的已用预算
     * @param ticketId
     * @return
     */
    long getBudgetOfToday(BigInteger ticketId);

    /**
     * 返回广告券今日指定时间段的已用预算
     * @param ticketId
     * @param startHour
     * @param endHour
     * @return
     * @throws IllegalArgumentException
     */
    long getBudgetOfTimeline(BigInteger ticketId, int startHour, int endHour) throws IllegalArgumentException;

}
