package com.bxm.adsprod.facade.ticket;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

/**
 * <h3>广告券权重服务</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
public interface TicketWeightService {

    /**
     * 根据将发放的广告券集合进行权重算法计算后返回下一张需要发放的广告券。
     * @param tickets 可出的广告券
     * @param uid UID
     * @param last 用户最后一次获取的广告券
     * @param position 广告位
     * @return
     */
    TicketCache getBest(List<TicketCache> tickets, String uid, Ticket last, String position);

    /**
     * 设置广告券的权重
     * @param position
     * @param ticketId
     * @param weight
     */
    void setWeight(String position, BigInteger ticketId, BigDecimal weight);

    /**
     * 获取广告券的权重
     * @param position
     * @param ticketId
     * @return
     */
    BigDecimal getWeight(String position, BigInteger ticketId);
}
