package com.bxm.adsprod.facade.media;

import java.math.BigInteger;
import java.util.Map;

/**
 * 广告位组织服务（流量包）
 *
 * @author allen
 * @since 1.0.0
 */
public interface PositionGroupService {

    /**
     * 获取这个广告券所配置的广告位组的今日消耗。
     *
     * @param ticketId
     * @return Key=广告位组ID、Value=今日消耗
     */
    Map<String, Long> getBudgetOfToday(BigInteger ticketId);

    /**
     * 获取这个广告券指定广告位组的今日消耗
     *
     * @param ticketId
     * @param groupId
     * @return
     */
    long getBudgetOfToday(BigInteger ticketId, String groupId);

    /**
     * 为广告券的广告位组增加今日消耗。如果这个广告位在这个广告券中有组织，那么才会增加，否则直接返回 0
     *
     * @param ticketId
     * @param position
     * @param incValue
     * @return
     */
    long incrementIfNecessary(BigInteger ticketId, String position, long incValue);

    /**
     * 为广告券的广告位组增加今日消耗
     *
     * @param ticketId
     * @param groupId
     * @param incValue 增量值
     * @return
     */
    long increment(BigInteger ticketId, String groupId, long incValue);
}
