package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigInteger;

/**
 * <h3>广告券统计服务</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/06
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface TicketStatisticsService {

    /**
     * 返回广告券今日的已用预算
     * @param ticketId
     * @return
     */
    @RequestMapping("/ticketStatisticsService/getBudgetOfToday")
    long getBudgetOfToday(@RequestParam("ticketId") BigInteger ticketId);

    /**
     * 返回广告券今日指定时间段的已用预算
     * @param ticketId
     * @param startHour
     * @param endHour
     * @return
     * @throws IllegalArgumentException
     */
    @RequestMapping("/ticketStatisticsService/getBudgetOfTimeline")
    long getBudgetOfTimeline(@RequestParam("ticketId") BigInteger ticketId,
                             @RequestParam("startHour") int startHour,
                             @RequestParam("endHour") int endHour) throws IllegalArgumentException;

}
