package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import com.bxm.adsprod.facade.ticket.weight.WeightRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

/**
 * <h3>广告券权重服务</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface TicketWeightService {
    /**
     * 排序后返回带权重的结果集
     *
     * @param tickets 可出的广告券
     * @param uid UID
     * @param last 用户最后一次获取的广告券
     * @param position 广告位
     * @return 已排序的结果集
     */
    @RequestMapping("/ticketWeightService/sort")
    List<TicketWithWeight> sort(List<TicketCache> tickets, String uid, Ticket last, String position);

    /**
     * 根据将发放的广告券集合进行权重算法计算后返回下一张需要发放的广告券。
     * @param tickets 可出的广告券
     * @param uid UID
     * @param last 用户最后一次获取的广告券
     * @param position 广告位
     * @return
     */
    @RequestMapping("/ticketWeightService/getBest1")
    TicketCache getBest(List<TicketCache> tickets, String uid, Ticket last, String position);

    /**
     * 根据将发放的广告券集合进行权重(这个权重来自参数<code>definedWeight</code>)算法计算后返回下一张需要发放的广告券。
     *
     * @param tickets 可出的广告券
     * @param uid UID
     * @param last 用户最后一次获取的广告券
     * @param position 广告位
     * @param definedWeight 自定权重
     * @return
     */
    @RequestMapping("/ticketWeightService/getBest")
    TicketCache getBest(List<TicketCache> tickets, String uid, Ticket last, String position, Map<BigInteger, BigDecimal> definedWeight);

    /**
     * 设置广告券的权重
     * @param position
     * @param ticketId
     * @param weight
     */
    @RequestMapping("/ticketWeightService/setWeight")
    void setWeight(@RequestParam("position") String position,
                   @RequestParam("ticketId") BigInteger ticketId,
                   @RequestParam("weight") BigDecimal weight);

    /**
     * 获取广告券的权重
     * @param position
     * @param ticketId
     * @return
     */
    @RequestMapping("/ticketWeightService/getWeight")
    BigDecimal getWeight(@RequestParam("position") String position,
                         @RequestParam("ticketId") BigInteger ticketId);
}
