package com.bxm.adsprod.facade.media;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <h3>开发者的用户信息请求对象</h3>
 *
 * @author kerry.jiang
 * @date 2019-9-3 11:53
 */
public class UserMediaRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;

    /**
     * 用户ID,唯一标识,如果没有user_id的情况下传imei或者idfa
     */
    @ValidateNotNull
    private String user_id;
    /**
     * 用户头像
     */
    private String headimgurl;
    /**
     * 用户昵称
     */
    private String nickname;
    /**
     * 用户性别,1:男性,2:女性,3:未知
     */
    private Byte gender;
    /**
     * 开发者KEY,用于校验身份
     */
    @ValidateNotNull
    private String appkey;
    /**
     * 广告位ID
     */
    @ValidateNotNull
    private String position_id;
    /**
     * 渠道号,开发者自定义
     */
    private String channel;

    public String getUser_id() {
        return user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public String getHeadimgurl() {
        return headimgurl;
    }

    public void setHeadimgurl(String headimgurl) {
        this.headimgurl = headimgurl;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Byte getGender() {
        return gender;
    }

    public void setGender(Byte gender) {
        this.gender = gender;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getPosition_id() {
        return position_id;
    }

    public void setPosition_id(String position_id) {
        this.position_id = position_id;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
