package com.bxm.adsprod.facade.ticket.inspirevideo;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * 激励视频配置.</br>
 * @author zhengwangeng
 * @date 2019年08月7日上午10:45:28
 */
public class TicketInspireVideo implements Serializable {

    private static final long serialVersionUID = 1733401522239243683L;

    //落地页类型，1下载类，2表单类，3deeplink
    /**
     * 下载类
     */
    public static final short PAGETYPE_DOWNLOAD = 1;
    /**
     * 表单类
     */
    public static final short PAGETYPE_FORM = 2;
    /**
     * deeplink
     */
    public static final short PAGETYPE_DEEPLINK = 3;

    /**
     * 广告券ID
     */
    private BigInteger ticketId;

    /**
     * 落地页类型，1下载类，2表单类，3deeplink
     */
    private Short pageType;

    /**
     * 下载安装包的AppID/包名
     */
    private String packageName;

    /**
     * 跳转地址
     */
    private String jumpUrl;

    /**
     * 未安装下载地址
     */
    private String unInstallDownloadUrl;

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    public Short getPageType() {
        return pageType;
    }

    public void setPageType(Short pageType) {
        this.pageType = pageType;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getUnInstallDownloadUrl() {
        return unInstallDownloadUrl;
    }

    public void setUnInstallDownloadUrl(String unInstallDownloadUrl) {
        this.unInstallDownloadUrl = unInstallDownloadUrl;
    }
}
