package com.bxm.adsprod.facade.award;

import java.io.Serializable;

/**
 * 奖品信息封装
 *
 * @ClassName Award
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/23 18:15
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/23 18:15
 **/
public class Award implements Serializable{
	private static final long serialVersionUID = 1936807165088551325L;
	
	public static final int LANDING_TYPE_DEFAULT = 0;
	public static final int LANDING_TYPE_MICROAPP = 1;

	/**
	 * 奖品名称
	 */
	private String awardname;

	/**
	 * 奖品图片
	 */
	private String awardimg;

	/**
	 * 素材介绍
	 */
	private String awardmsg;

	/**
	 * 奖品ID
	 */
	private Long awardid;

	/**
	 * 奖品链接
	 */
	private String awardlink;

	/**
	 * 奖品类型 1-奖品 2-礼券
	 */
	private Integer awardtype;

	/**
	 * 按钮名称
	 */
	private String buttontext;

	/**
	 * 有效期
	 */
	private String validitytime;

	/**
	 * 抽奖记录的数据库ID
	 */
	private Long awardorderid;

	/**
	 * 当前活动是否可以继续
	 */
	private Boolean iscontinue;

	/**
	 * 礼券的行业类型
	 */
	private Integer shopstype;

	/**
	 * 大转盘的固定旋转角度 300
	 */
	private String awardangle = "300";

	/**
	 * 抽到奖品--奖品流水号，抽到礼券--null
	 */
	private String ordernum;

	/**
	 * 废弃状态 TODO
	 */
	private Integer state;

	/**
	 * 素材ID
	 */
	private Long assetsId;

	/**
	 * 0= 普通落地页、1= 小程序
	 */
	private int landingType = 0;
	
	/**
	 * 首张弹窗
	 */
	private PopupVo firstPopup;

	/**
	 * 挽留弹窗
	 */
	private PopupVo detainPopup;

	/**
	 * 素材是否屏蔽弹窗
	 */
	private String isShieldPopup;

	/**
	 * 票据
	 */
	private String ticket;

	/**
	 *  bxmId
	 */
	private String bxmId;

	/**
	 * 算法名称
	 */
	private String algorithmlName;


	public String getIsShieldPopup() {
		return isShieldPopup;
	}

	public void setIsShieldPopup(String isShieldPopup) {
		this.isShieldPopup = isShieldPopup;
	}

	public PopupVo getFirstPopup() {
		return firstPopup;
	}

	public void setFirstPopup(PopupVo firstPopup) {
		this.firstPopup = firstPopup;
	}

	public PopupVo getDetainPopup() {
		return detainPopup;
	}

	public void setDetainPopup(PopupVo detainPopup) {
		this.detainPopup = detainPopup;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public String getOrdernum() {
		return ordernum;
	}

	public void setOrdernum(String ordernum) {
		this.ordernum = ordernum;
	}

	public String getAwardangle() {
		return awardangle;
	}

	public void setAwardangle(String awardangle) {
		this.awardangle = awardangle;
	}

	public Integer getShopstype() {
		return shopstype;
	}

	public void setShopstype(Integer shopstype) {
		this.shopstype = shopstype;
	}

	public Boolean getIscontinue() {
		return iscontinue;
	}

	public void setIscontinue(Boolean iscontinue) {
		this.iscontinue = iscontinue;
	}

	public Long getAwardorderid() {
		return awardorderid;
	}

	public void setAwardorderid(Long awardorderid) {
		this.awardorderid = awardorderid;
	}

	public String getValiditytime() {
		return validitytime;
	}

	public void setValiditytime(String validitytime) {
		this.validitytime = validitytime;
	}

	public String getButtontext() {
		return buttontext;
	}

	public void setButtontext(String buttontext) {
		this.buttontext = buttontext;
	}

	public Integer getAwardtype() {
		return awardtype;
	}
 
    public Long getAssetsId() {
        return assetsId;
    }
    public void setAssetsId(Long assetsId) {
        this.assetsId = assetsId;
    }

    public void setAwardtype(Integer awardtype) {
		this.awardtype = awardtype;
	}

	public String getAwardname() {
		return awardname;
	}

	public void setAwardname(String awardname) {
		this.awardname = awardname;
	}

	public String getAwardimg() {
		return awardimg;
	}

	public void setAwardimg(String awardimg) {
		this.awardimg = awardimg;
	}

	public String getAwardmsg() {
		return awardmsg;
	}

	public void setAwardmsg(String awardmsg) {
		this.awardmsg = awardmsg;
	}

	public Long getAwardid() {
		return awardid;
	}

	public void setAwardid(Long awardid) {
		this.awardid = awardid;
	}

	public String getAwardlink() {
		return awardlink;
	}

	public void setAwardlink(String awardlink) {
		this.awardlink = awardlink;
	}

	public int getLandingType() {
		return landingType;
	}

	public void setLandingType(int landingType) {
		this.landingType = landingType;
	}

	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	public String getBxmId() {
		return bxmId;
	}

	public void setBxmId(String bxmId) {
		this.bxmId = bxmId;
	}

	public String getAlgorithmlName() {
		return algorithmlName;
	}

	public void setAlgorithmlName(String algorithmlName) {
		this.algorithmlName = algorithmlName;
	}
}
