package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <h3>激励视频请求对象</h3>
 *
 * @author kerry.jiang
 * @date 2019/8/5 17:55
 */
public class TicketInspireRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;
    /**
     * 用户ID,判断曝光次数等
     */
    @ValidateNotNull
    private String uid;
    /**
     * 设备号
     */
    private String imei;
    /**
     * 平台
     * @see Platform
     */
    private int platform = Platform.MOBILE;
    /**
     * 用户设备操作系统
     * @see Os
     */
    private int os = Os.UNKNOWN;
    /**
     * 应用
     * @see App
     */
    private int app = App.UNKNOWN;
    /**
     * 用户IP地址
     */
    @ValidateNotNull
    private String ipaddress;

    /**
     * 广告位
     */
    @ValidateNotNull
    private String position;

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public int getPlatform() {
        return platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public int getOs() {
        return os;
    }

    public void setOs(int os) {
        this.os = os;
    }

    public int getApp() {
        return app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    public String getIpaddress() {
        return ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
