package com.bxm.adsprod.facade.ticket.adx;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * 广告券adx投放信息
 * @author allen
 * @date 2019/7/16
 * @since 1.0.0
 */
public class TicketAdx implements Serializable {

    private static final long serialVersionUID = 8471920700560060581L;

    /**
     * 加速投放
     */
    public static final short SPEED_UP = 1;
    /**
     * 匀速投放
     */
    public static final short SPEED_AVG = 2;
    /**
     * 内部人群
     */
    public static final short CROWD_SOURCE_INNER = 0;

    private BigInteger adTicketId;
    private Integer showMaximum;
    private Integer clickMaximum;
    /**
     * 投放速度。
     * @see #SPEED_UP
     * @see #SPEED_AVG
     */
    private short speed;
    /**
     * 人群来源。
     * @see #CROWD_SOURCE_INNER
     */
    private short crowdSource;

    public BigInteger getAdTicketId() {
        return adTicketId;
    }

    public void setAdTicketId(BigInteger adTicketId) {
        this.adTicketId = adTicketId;
    }

    public Integer getShowMaximum() {
        return showMaximum;
    }

    public void setShowMaximum(Integer showMaximum) {
        this.showMaximum = showMaximum;
    }

    public Integer getClickMaximum() {
        return clickMaximum;
    }

    public void setClickMaximum(Integer clickMaximum) {
        this.clickMaximum = clickMaximum;
    }

    public short getSpeed() {
        return speed;
    }

    public void setSpeed(short speed) {
        this.speed = speed;
    }

    public short getCrowdSource() {
        return crowdSource;
    }

    public void setCrowdSource(short crowdSource) {
        this.crowdSource = crowdSource;
    }
}
