package com.bxm.adsprod.facade.ticket.adx;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Lists;

/**
 * @author allen
 * @date 2019/7/16
 * @since 1.0.0
 */
public class TicketAdxCreative implements Serializable {

    private static final long serialVersionUID = 1733401522239243683L;

    /**
     * 原生广告
     */
    public static final short POSITION_TYPE_NATIVE = 1;
    /**
     * 图片广告
     */
    public static final short POSITION_TYPE_PICTURE = 2;
    /**
     * 视频广告
     */
    public static final short POSITION_TYPE_VIDEO = 3;
    /**
     * 文本广告
     */
    public static final short POSITION_TYPE_TEXT = 4;

    /**
     * 等待提交
     */
    public static final short STATUS_WAIT_SUBMIT = 0;
    /**
     * 提交失败
     */
    public static final short STATUS_SUBMIT_FAIL = 1;
    /**
     * 审核中
     */
    public static final short STATUS_CHECKING = 2;
    /**
     * 审核失败
     */
    public static final short STATUS_CHECK_FAIL = 3;
    /**
     * 审核通过
     */
    public static final short STATUS_SUCCESS = 4;

    private BigInteger creativeId;//素材id
    private BigInteger adTicketId;
    private BigInteger adTicketAdxId;
    private String positionId;
    private short positionType;
    private String positionTypeDesc;
    private String showUrl;
    private String clickUrl;
    private String creativeName;
    private String creativeIcon;
    private String creativeTitle;
    private String creativeContent;
    private String creativePicture;
    private short status = STATUS_WAIT_SUBMIT;

    public boolean isSuccess() {
        return status == STATUS_SUCCESS;
    }

    public List<String> getCreativeContentList() {
        if(StringUtils.isBlank(this.getCreativeContent())){
            return null;
        }
        return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativeContent(), ","));
    }

    public List<String> getCreativePictures() {
        if(StringUtils.isBlank(this.getCreativePicture())){
            return null;
        }
        return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativePicture(), ","));
    }

    public BigInteger getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(BigInteger creativeId) {
        this.creativeId = creativeId;
    }

    public BigInteger getAdTicketId() {
        return adTicketId;
    }

    public void setAdTicketId(BigInteger adTicketId) {
        this.adTicketId = adTicketId;
    }

    public BigInteger getAdTicketAdxId() {
        return adTicketAdxId;
    }

    public void setAdTicketAdxId(BigInteger adTicketAdxId) {
        this.adTicketAdxId = adTicketAdxId;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public short getPositionType() {
        return positionType;
    }

    public void setPositionType(short positionType) {
        this.positionType = positionType;
    }

    public String getPositionTypeDesc() {
        return positionTypeDesc;
    }

    public void setPositionTypeDesc(String positionTypeDesc) {
        this.positionTypeDesc = positionTypeDesc;
    }

    public String getShowUrl() {
        return showUrl;
    }

    public void setShowUrl(String showUrl) {
        this.showUrl = showUrl;
    }

    public String getClickUrl() {
        return clickUrl;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    public String getCreativeName() {
        return creativeName;
    }

    public void setCreativeName(String creativeName) {
        this.creativeName = creativeName;
    }

    public String getCreativeIcon() {
        return creativeIcon;
    }

    public void setCreativeIcon(String creativeIcon) {
        this.creativeIcon = creativeIcon;
    }

    public String getCreativeTitle() {
        return creativeTitle;
    }

    public void setCreativeTitle(String creativeTitle) {
        this.creativeTitle = creativeTitle;
    }

    public String getCreativeContent() {
        return creativeContent;
    }

    public void setCreativeContent(String creativeContent) {
        this.creativeContent = creativeContent;
    }

    public String getCreativePicture() {
        return creativePicture;
    }

    public void setCreativePicture(String creativePicture) {
        this.creativePicture = creativePicture;
    }

    public short getStatus() {
        return status;
    }

    public void setStatus(short status) {
        this.status = status;
    }
}
