package com.bxm.adsprod.facade.video;

import com.bxm.adsprod.facade.resolve.UrlParam;
import com.bxm.adsprod.facade.resolve.UseFixedValue;
import com.bxm.warcar.validate.annotation.ValidateNotNull;

import java.io.Serializable;

/**
 * @author: zm
 * @Date: 2019/8/1 0001 16:14
 * @Description: 视频上报设备公参
 */
public class EquipmentRedordDto implements Serializable {

    private static final long serialVersionUID = -1L;


    /**
     * //设备id
     */
    @UrlParam(urlParamName = "devid")
    @ValidateNotNull
    private String deviceid;

    @UrlParam(urlParamName = "imei")
    private String imei;

    @UrlParam(urlParamName = "idfa")
    @ValidateNotNull
    private String idfa;

    @UrlParam(urlParamName = "mac")
    private String mac;

    @UrlParam(urlParamName = "ip")
    private String ipaddress;


    /**
     * //经度
     */
    @UrlParam(urlParamName = "lon")
    private String lon;


    /**
     * //纬度
     */
    @UrlParam(urlParamName = "lat")
    private String lat;


    /**
     * 设备型号  机型
     */
    @UrlParam(urlParamName = "devm")
    private String equipmentModel;
    /**
     * 设备品牌
     */
    @UrlParam(urlParamName = "devb")
    private String equipmentBrand;


    /**
     * 设备类型（手机、平板）
     */
    @UrlParam(urlParamName = "devt")
    private String equipmentType;

    /**
     * 内存
     */
    @UrlParam(urlParamName = "dmem")
    private Double memory;
    /**
     * 存储空间
     */
    @UrlParam(urlParamName = "dstg")
    private Double storageSpace;


    /**
     * cpu型号
     */
    @UrlParam(urlParamName = "cpu")
    private String cpuModel;

    /**
     * 安装应用列表
     */
    @UrlParam(urlParamName = "appl")
    private String applications;


    /**
     * 安卓或者ios系统版本号
     */
    @UrlParam(urlParamName = "osv")
    private String systemVersion;

    /**
     * 安装应用的包名
     */
    @UrlParam(urlParamName = "pack")
    @ValidateNotNull
    private String packageName;

    /**
     * 手机网络运行商 移动、联通、电信
     */
    @UrlParam(urlParamName = "isp")
    private String networkOperator;

    /**
     * sdk版本
     */
    @UrlParam(urlParamName = "sdkv")
    private String sdkVersion;

    @UrlParam(urlParamName = "appkey")
    @ValidateNotNull
    private String appkey;


    /**
     * 联网方式
     */
    @UrlParam(urlParamName = "net")
    private String net;

    /**
     * 埋点默认值,不可更改(埋点类型)
     */
    @UrlParam(urlParamName = "mt")
    @UseFixedValue("13001")
    private String mt;


    public String getDeviceid() {
        return deviceid;
    }

    public void setDeviceid(String deviceid) {
        this.deviceid = deviceid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getIpaddress() {
        return ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public String getEquipmentModel() {
        return equipmentModel;
    }

    public void setEquipmentModel(String equipmentModel) {
        this.equipmentModel = equipmentModel;
    }

    public String getEquipmentBrand() {
        return equipmentBrand;
    }

    public void setEquipmentBrand(String equipmentBrand) {
        this.equipmentBrand = equipmentBrand;
    }

    public Double getMemory() {
        return memory;
    }

    public void setMemory(Double memory) {
        this.memory = memory;
    }

    public Double getStorageSpace() {
        return storageSpace;
    }

    public void setStorageSpace(Double storageSpace) {
        this.storageSpace = storageSpace;
    }

    public String getCpuModel() {
        return cpuModel;
    }

    public void setCpuModel(String cpuModel) {
        this.cpuModel = cpuModel;
    }

    public String getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getSystemVersion() {
        return systemVersion;
    }

    public void setSystemVersion(String systemVersion) {
        this.systemVersion = systemVersion;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getNetworkOperator() {
        return networkOperator;
    }

    public void setNetworkOperator(String networkOperator) {
        this.networkOperator = networkOperator;
    }

    public String getSdkVersion() {
        return sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getApplications() {
        return applications;
    }

    public void setApplications(String applications) {
        this.applications = applications;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getLon() {
        return lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getNet() {
        return net;
    }

    public void setNet(String net) {
        this.net = net;
    }


    public String getMt() {
        return mt;
    }

    public void setMt(String mt) {
        this.mt = mt;
    }
}
