package com.bxm.adsprod.facade.strategy;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author allen
 * @date 2020-08-19
 * @since 1.0
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface UniformSpeedStrategyFacadeService {

    /**
     * 设置匀速消耗策略
     * @param config 策略对象
     */
    @PostMapping("/UniformSpeedStrategyFacadeService/set")
    void set(@RequestBody UniformSpeedStrategyConfiguration config);

    /**
     * 删除策略
     * @param id 主键
     */
    @RequestMapping("/UniformSpeedStrategyFacadeService/remove")
    void remove(@RequestParam("id") String id);

    /**
     * 记录消耗
     * @param id 主键
     * @param value 消耗值
     */
    @RequestMapping("/UniformSpeedStrategyFacadeService/consume")
    void consume(@RequestParam("id") String id,
                 @RequestParam("value") long value);
}
