package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.utils.Constants;

import java.util.List;

/**
 * @author zxdong
 * @time 2018年3月27日19:59:32
 */
public class TicketGroupPushVo{

    /**
     * 每天
     */
    public static final Integer EVERY_DAY = 1;
    /**
     * 每周
     */
    public static final Integer EVERY_WEEK = 2;

        /**
         * 广告券 ID 集合
         */
        private List<Long> ticketIds;

        /**
         * 广告组状态，开启：1，关闭：0
         */
        private Integer status;
        /**
         * 曝光频次限制，1每天，2：每周
         */
        private Integer openFrequency;
        /**
         * '曝光频次限制时间'
         */
        private Integer openFrequencyNum;
        /**
         * 点击频次限制，1：每天，2：每周
         */
        private Integer clickFrequency;
        /**
         * 曝光频次限制时间
         */
        private Integer clickFrequencyNum;

        public boolean isEnabled() {
            return status != null && status == Constants.YES;
        }

        public List<Long> getTicketIds() {
            return ticketIds;
        }

        public void setTicketIds(List<Long> ticketIds) {
            this.ticketIds = ticketIds;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getOpenFrequency() {
            return openFrequency;
        }

        public void setOpenFrequency(Integer openFrequency) {
            this.openFrequency = openFrequency;
        }

        public Integer getOpenFrequencyNum() {
            return openFrequencyNum;
        }

        public void setOpenFrequencyNum(Integer openFrequencyNum) {
            this.openFrequencyNum = openFrequencyNum;
        }

        public Integer getClickFrequency() {
            return clickFrequency;
        }

        public void setClickFrequency(Integer clickFrequency) {
            this.clickFrequency = clickFrequency;
        }

        public Integer getClickFrequencyNum() {
            return clickFrequencyNum;
        }

        public void setClickFrequencyNum(Integer clickFrequencyNum) {
            this.clickFrequencyNum = clickFrequencyNum;
        }
    }
