package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

/**
 * 激励视频信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/10/9 15:18
 */
public class TicketInspireSsp implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    /**
     * 广告券ID
     */
    private BigInteger id;
    /**
     * 广告响应id,和requestId保持一致
     */
    private String responseId;
    /**
     * 变现猫广告位id
     */
    private String position;
    /**
     * 落地页地址
     */
    private String url;
    /**
     * 落地页类型，1为下载类，2为表单类
     */
    private Short pageType;
    /**
     * APP包名
     */
    private String packageName;
    /**
     * 视频地址
     */
    private String videoUrl;
    /**
     * 封面地址
     */
    private String coverUrl;
    /**
     * 标题
     */
    private String title;
    /**
     * icon地址
     */
    private String iconUrl;
    /**
     * 按钮地址
     */
    private String btnUrl;
    /**
     * 结束页
     */
    private TicketInspireOverPage overPage;
    /**
     * 监测信息
     */
    private TicketInspireTracker tracker;

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getResponseId() {
        return responseId;
    }

    public void setResponseId(String responseId) {
        this.responseId = responseId;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Short getPageType() {
        return pageType;
    }

    public void setPageType(Short pageType) {
        this.pageType = pageType;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public String getCoverUrl() {
        return coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getBtnUrl() {
        return btnUrl;
    }

    public void setBtnUrl(String btnUrl) {
        this.btnUrl = btnUrl;
    }

    public TicketInspireOverPage getOverPage() {
        return overPage;
    }

    public void setOverPage(TicketInspireOverPage overPage) {
        this.overPage = overPage;
    }

    public TicketInspireTracker getTracker() {
        return tracker;
    }

    public void setTracker(TicketInspireTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
