package com.bxm.adsprod.facade.ticket.fallback;

import java.math.BigInteger;
import java.util.List;

import com.bxm.adsprod.facade.ticket.*;
import org.springframework.context.annotation.Configuration;

import com.bxm.adsprod.facade.award.AwardDto;

/**
 * @author allen
 * @date 2019/1/10
 * @since 1.0.0
 */
@Configuration
public class TicketServiceFallback implements TicketService {

    @Override
    public Ticket get(TicketRequest request) {
        return null;
    }

    @Override
    public Ticket view(ViewRequest viewRequest) throws IllegalTicketException {
        return null;
    }

    @Override
    public Ticket click(ClickRequest clickRequest) throws IllegalTicketException {
        return null;
    }

    @Override
    public List<Ticket> getAllTickets() {
        return null;
    }

    @Override
    public Ticket get(BigInteger ticketId) {
        return null;
    }

    @Override
    public boolean updateTicketStatus(BigInteger ticketId, byte status, int reason) throws IllegalTicketException {
        return false;
    }

    @Override
    public void updateTicketGroupId(BigInteger ticketId, Long groupId) {

    }

    @Override
    public Ticket getDirectTicket(AwardDto request) {
        return null;
    }

    /**
     * 更新广告券状态
     *
     * @param ticketId       广告券
     * @param status         需要更新到这个状态
     * @param reason         这个状态的原因，一般暂停才会用到
     * @param syncAdsmanager 是否请求后台系统，默认不请求
     * @return 更新是否成功
     * @throws IllegalTicketException
     * @see Ticket#STATUS_PAUSE
     * @see Ticket#PAUSE_REASON_OUT_OF_DAILYBUDGET
     */
    @Override
    public boolean updateTicketStatus(BigInteger ticketId, byte status, int reason, boolean syncAdsmanager) throws IllegalTicketException {
        return false;
    }

    @Override
    public TicketCache getAvailableTicket(BigInteger ticketId) {
        return null;
    }

    @Override
    public List<TicketCoupon> getCoupon(TicketCouponRequest request) {
        return null;
    }

    @Override
    public Boolean bindCoupon(BindCouponRequest request) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean useCoupon(BindCouponRequest request) {
        return Boolean.FALSE;
    }

    @Override
    public List<CheckCoupon> checkCoupon(CheckCouponRequest request) {
        return null;
    }

    @Override
    public TicketInspire getInspire(TicketInspireRequest request) {
        return null;
    }

    @Override
    public TicketInspireApi getInspireVideo(TicketInspireApiRequest request) {
        return null;
    }

    @Override
    public TicketInspireSsp getInspireVideoForSsp(TicketInspireSspRequest request) {
        return null;
    }
}
