package com.bxm.adsprod.facade.ticket.inspirevideo;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * 激励视频素材.</br>
 * @author zhengwangeng
 * @date 2019年08月7日上午10:45:28
 */
public class TicketInspireVideoCreative implements Serializable {

    private static final long serialVersionUID = 1733401522239243683L;

    //状态。0- 停用、1- 启用 2- 删除
    /**
     * 停用
     */
    public static final short STATUS_DISABLE = 0;
    /**
     * 启用
     */
    public static final short STATUS_ACTIVATE = 1;
    /**
     * 删除
     */
    public static final short STATUS_DELETE = 2;

    /**
     * 素材id
     */
    private BigInteger creativeId;

    /**
     * 广告券ID
     */
    private BigInteger ticketId;

    /**
     * 视频
     */
    private String videoUrl;

    /**
     * 视频时长
     */
    private Double videoDuration;

    /**
     * 封面
     */
    private String coverUrl;

    /**
     * 标题
     */
    private String title;

    /**
     * 副标题
     */
    private String subtitle;

    /**
     * ICON
     */
    private String iconUrl;

    /**
     * 按钮
     */
    private String buttonUrl;

    /**
     * 是否有结束页
     */
    private Short endPageFlag;

    /**
     * 结束页轮播图片，多个按英文逗号分隔。允许空元素。如：url,url
     */
    private String endPagePictures;

    /**
     * 结束页按钮
     */
    private String endPageButtonUrl;

    /**
     * 结束页样式：1默认样式，2自定义
     */
    private Short endPageStyleType;

    /**
     * 结束页地址
     */
    private String endPageUrl;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private short status = STATUS_DISABLE;

    /**
     * 素材名称
     */
    private String assetsName;

    /**
     * 广告内容
     */
    private String content;

    /**
     * 按钮内容
     */
    private String buttonContent;

    /**
     * 视频方向(1.横版 2.竖版)
     */
    private Short videoDirection;


    public BigInteger getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(BigInteger creativeId) {
        this.creativeId = creativeId;
    }

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public Double getVideoDuration() {
        return videoDuration;
    }

    public void setVideoDuration(Double videoDuration) {
        this.videoDuration = videoDuration;
    }

    public String getCoverUrl() {
        return coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getButtonUrl() {
        return buttonUrl;
    }

    public void setButtonUrl(String buttonUrl) {
        this.buttonUrl = buttonUrl;
    }

    public Short getEndPageFlag() {
        return endPageFlag;
    }

    public void setEndPageFlag(Short endPageFlag) {
        this.endPageFlag = endPageFlag;
    }

    public String getEndPagePictures() {
        return endPagePictures;
    }

    public void setEndPagePictures(String endPagePictures) {
        this.endPagePictures = endPagePictures;
    }

    public String getEndPageButtonUrl() {
        return endPageButtonUrl;
    }

    public void setEndPageButtonUrl(String endPageButtonUrl) {
        this.endPageButtonUrl = endPageButtonUrl;
    }

    public Short getEndPageStyleType() {
        return endPageStyleType;
    }

    public void setEndPageStyleType(Short endPageStyleType) {
        this.endPageStyleType = endPageStyleType;
    }

    public String getEndPageUrl() {
        return endPageUrl;
    }

    public void setEndPageUrl(String endPageUrl) {
        this.endPageUrl = endPageUrl;
    }

    public short getStatus() {
        return status;
    }

    public void setStatus(short status) {
        this.status = status;
    }

    public String getAssetsName() {
        return assetsName;
    }

    public void setAssetsName(String assetsName) {
        this.assetsName = assetsName;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getButtonContent() {
        return buttonContent;
    }

    public void setButtonContent(String buttonContent) {
        this.buttonContent = buttonContent;
    }

    public Short getVideoDirection() {
        return videoDirection;
    }

    public void setVideoDirection(Short videoDirection) {
        this.videoDirection = videoDirection;
    }
}
