package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;

/**
 * tbl_ad_ticket_app_extend
 * @author 
 */
public class TicketAppExtend implements Serializable {

    //落地页类型，1下载类，2表单类
    /**
     * 下载类
     */
    public static final short PAGETYPE_DOWNLOAD = 1;
    /**
     * 表单类
     */
    public static final short PAGETYPE_FORM = 2;

    //设备号定向 1.不限  2.仅设备号的流量
    /**
     * 不限
     */
    public final static short DEVICERULE_UNLIMITED = 1;
    /**
     * 有设备号的
     */
    public final static short DEVICERULE_EXIST = 2;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 券id
     */
    private Long ticketId;

    /**
     * 落地页类型，1下载类，2表单类
     */
    private Short pageType;

    /**
     * 下载安装包的AppID/包名
     */
    private String packageName;

    /**
     * deeplink跳转地址
     */
    private String jumpUrl;

    /**
     * 曝光监测URL
     */
    private String viewUrl;

    /**
     * 点击监测URL
     */
    private String clickUrl;

    /**
     * 视频开始播放地址监测URL
     */
    private String videoPlayStartUrl;

    /**
     * 视频播放完成地址监测URL
     */
    private String videoPlayEndUrl;

    /**
     * deeplink吊起开始监测URL
     */
    private String deeplinkStartUrl;

    /**
     * deeplink吊起成功监测URL
     */
    private String deeplinkSuccessUrl;

    /**
     * deeplink吊起失败监测URL
     */
    private String deeplinkFailUrl;

    /**
     * 未获取到App列表时投放配率 0 ~ 100
     */
    private Integer appPackageRate;

    /**
     * 设备号定向 1.不限  2.仅设备号的流量
     */
    private Short deviceRule;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Short getPageType() {
        return pageType;
    }

    public void setPageType(Short pageType) {
        this.pageType = pageType;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getViewUrl() {
        return viewUrl;
    }

    public void setViewUrl(String viewUrl) {
        this.viewUrl = viewUrl;
    }

    public String getClickUrl() {
        return clickUrl;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    public String getVideoPlayStartUrl() {
        return videoPlayStartUrl;
    }

    public void setVideoPlayStartUrl(String videoPlayStartUrl) {
        this.videoPlayStartUrl = videoPlayStartUrl;
    }

    public String getVideoPlayEndUrl() {
        return videoPlayEndUrl;
    }

    public void setVideoPlayEndUrl(String videoPlayEndUrl) {
        this.videoPlayEndUrl = videoPlayEndUrl;
    }

    public String getDeeplinkStartUrl() {
        return deeplinkStartUrl;
    }

    public void setDeeplinkStartUrl(String deeplinkStartUrl) {
        this.deeplinkStartUrl = deeplinkStartUrl;
    }

    public String getDeeplinkSuccessUrl() {
        return deeplinkSuccessUrl;
    }

    public void setDeeplinkSuccessUrl(String deeplinkSuccessUrl) {
        this.deeplinkSuccessUrl = deeplinkSuccessUrl;
    }

    public String getDeeplinkFailUrl() {
        return deeplinkFailUrl;
    }

    public void setDeeplinkFailUrl(String deeplinkFailUrl) {
        this.deeplinkFailUrl = deeplinkFailUrl;
    }

    public Integer getAppPackageRate() {
        return appPackageRate;
    }

    public void setAppPackageRate(Integer appPackageRate) {
        this.appPackageRate = appPackageRate;
    }

    public Short getDeviceRule() {
        return deviceRule;
    }

    public void setDeviceRule(Short deviceRule) {
        this.deviceRule = deviceRule;
    }
}