package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.util.Date;

/**
 * 礼券过滤信息
 *
 * @ClassName TicketFilterInformation
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/10 15:47
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/10 15:47
 **/
public class TicketFilterInformation implements Serializable {
    private static final long serialVersionUID = -6471555093275395757L;

    /**
     * 开发者
     */
    private String appkey;

    /**
     * 子链接
     */
    private String business;

    /**
     * 地域拦截
     */
    private String region;

    /**
     * 用户操作平台拦截
     */
    private String useros;

    /**
     * 微信请求拦截
     */
    private String userapp;

    /**
     * 广告位拦截
     */
    private String position;

    /**
     * 用户频次拦截
     */
    private String times;

    /**
     * 用户评分拦截
     */
    private String usergrade;

    /**
     * 广告分组（流量包）拦截
     */
    private String positiongroup;

    /**
     * 日预算拦截
     */
    private String dailybudget;

    /**
     * 媒体报表过滤
     */
    private String mediatag;

    /**
     * 激励视频素材过滤
     */
    private String inspireAssets;

    /**
     * 激励视频已安装APP过滤
     */
    private String inspireInstalledApp;

    /**
     * 人群包过滤
     */
    private String crowdPack;

    /**
     * 已安装App包名过滤
     */
    private String installedAppPkn;

    /**
     * 设备过滤
     */
    private String device;

    /**
     * 过滤后出券前礼券集合
     */
    private String filterresult;

    /**
     * 分区 -- 创建消息时间
     */
    private Date pt;

    public Date getPt() {
        return pt;
    }

    public void setPt(Date pt) {
        this.pt = pt;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getUseros() {
        return useros;
    }

    public void setUseros(String useros) {
        this.useros = useros;
    }

    public String getUserapp() {
        return userapp;
    }

    public void setUserapp(String userapp) {
        this.userapp = userapp;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getTimes() {
        return times;
    }

    public void setTimes(String times) {
        this.times = times;
    }

    public String getUsergrade() {
        return usergrade;
    }

    public void setUsergrade(String usergrade) {
        this.usergrade = usergrade;
    }

    public String getPositiongroup() {
        return positiongroup;
    }

    public void setPositiongroup(String positiongroup) {
        this.positiongroup = positiongroup;
    }

    public String getDailybudget() {
        return dailybudget;
    }

    public void setDailybudget(String dailybudget) {
        this.dailybudget = dailybudget;
    }

    public String getMediatag() {
        return mediatag;
    }

    public void setMediatag(String mediatag) {
        this.mediatag = mediatag;
    }

    public String getInspireAssets() {
        return inspireAssets;
    }

    public void setInspireAssets(String inspireAssets) {
        this.inspireAssets = inspireAssets;
    }

    public String getInspireInstalledApp() {
        return inspireInstalledApp;
    }

    public void setInspireInstalledApp(String inspireInstalledApp) {
        this.inspireInstalledApp = inspireInstalledApp;
    }

    public String getCrowdPack() {
        return crowdPack;
    }

    public void setCrowdPack(String crowdPack) {
        this.crowdPack = crowdPack;
    }

    public String getInstalledAppPkn() {
        return installedAppPkn;
    }

    public void setInstalledAppPkn(String installedAppPkn) {
        this.installedAppPkn = installedAppPkn;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getFilterresult() {
        return filterresult;
    }

    public void setFilterresult(String filterresult) {
        this.filterresult = filterresult;
    }

    @Override
    public String toString() {
        return "TicketFilterInformation{" +
                "appkey='" + appkey + '\'' +
                ", business='" + business + '\'' +
                ", region='" + region + '\'' +
                ", useros='" + useros + '\'' +
                ", userapp='" + userapp + '\'' +
                ", position='" + position + '\'' +
                ", times='" + times + '\'' +
                ", usergrade='" + usergrade + '\'' +
                ", positiongroup='" + positiongroup + '\'' +
                ", dailybudget='" + dailybudget + '\'' +
                ", mediatag='" + mediatag + '\'' +
                ", inspireAssets='" + inspireAssets + '\'' +
                ", inspireInstalledApp='" + inspireInstalledApp + '\'' +
                ", installedAppPkn='" + installedAppPkn + '\'' +
                ", device='" + device + '\'' +
                ", filterresult='" + filterresult + '\'' +
                '}';
    }
}
