package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <h3>激励视频请求对象</h3>
 *
 * @author kerry.jiang
 * @date 2019/8/5 17:55
 */
public class TicketInspireApiRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;
    /**
     * 广告请求id
     */
    @ValidateNotNull
    private String request_id;
    /**
     * 广告位ID
     */
    @ValidateNotNull
    private String position;
    /**
     * app信息
     */
    @ValidateNotNull
    private AppInfo app;
    /**
     * 设备信息
     */
    @ValidateNotNull
    private DeviceInfo device;
    /**
     * 请求来源
     */
    private String referer;
    /**
     * 用户当前请求的域
     */
    private String origin;
    /**
     * User agent
     */
    private String ua;

    public String getRequest_id() {
        return request_id;
    }

    public void setRequest_id(String request_id) {
        this.request_id = request_id;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public AppInfo getApp() {
        return app;
    }

    public void setApp(AppInfo app) {
        this.app = app;
    }

    public DeviceInfo getDevice() {
        return device;
    }

    public void setDevice(DeviceInfo device) {
        this.device = device;
    }

    public String getReferer() {
        return referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /**
     * app信息
     */
    public static class AppInfo implements Serializable {

        private static final long serialVersionUID = 1132577199900938728L;
        /**
         * 应用名
         */
        private String name;
        /**
         * 应用唯一标识，安卓为包名，IOS为number ID
         */
        private String bundle;
        /**
         * APP类型
         */
        private String car;
        /**
         * App对应的域名，例如mygame.foo.com
         */
        private String domain;
        /**
         * App在应用商店的下载链接
         */
        private String storeurl;
        /**
         * 保留字段
         */
        private String ext;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBundle() {
            return bundle;
        }

        public void setBundle(String bundle) {
            this.bundle = bundle;
        }

        public String getCar() {
            return car;
        }

        public void setCar(String car) {
            this.car = car;
        }

        public String getDomain() {
            return domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getStoreurl() {
            return storeurl;
        }

        public void setStoreurl(String storeurl) {
            this.storeurl = storeurl;
        }

        public String getExt() {
            return ext;
        }

        public void setExt(String ext) {
            this.ext = ext;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    /**
     * 设备信息
     */
    public static class DeviceInfo implements Serializable {

        private static final long serialVersionUID = 1132577199900938728L;
        /**
         * 用户真实公网IP，如 12.34.56.78
         */
        @ValidateNotNull
        private String ip;
        /**
         * 操作系统，1：安卓 2：IOS 3：windows phone 4：未知
         */
        @ValidateNotNull
        private Integer os;
        /**
         * IMEI值（可传原始值或小写MD5值）
         */
        @ValidateImeiOrIdfa
        private String imei;
        /**
         * IDFA值（可传原始值或小写MD5值）
         */
        @ValidateImeiOrIdfa
        private String idfa;
        /**
         * 设备id
         */
        private String deviceid;
        /**
         * 保留字段
         */
        private String ext;

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Integer getOs() {
            return os;
        }

        public void setOs(Integer os) {
            this.os = os;
        }

        public String getImei() {
            return imei;
        }

        public void setImei(String imei) {
            this.imei = imei;
        }

        public String getIdfa() {
            return idfa;
        }

        public void setIdfa(String idfa) {
            this.idfa = idfa;
        }

        public String getDeviceid() {
            return deviceid;
        }

        public void setDeviceid(String deviceid) {
            this.deviceid = deviceid;
        }

        public String getExt() {
            return ext;
        }

        public void setExt(String ext) {
            this.ext = ext;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}
