package com.bxm.adsprod.facade.ticket;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <h3>广告券-分时段对广告位限制配置</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2021/3/9 09:45
 */
@Builder
@Data
public class TicketPositionTimesLimitConfig implements Serializable {

    private static final long serialVersionUID = 2295350152450671383L;
    private Long id;

    /**
     * 配置名称
     */
    private String configName;

    /**
     *  开始时间,精确到小时，24小时格式 如 上午0:59 就是 0
     *  闭区间 >=
     * {@see LocalDateTime.now().getHour() }
     */
    private int startHour;

    /**
     * 开始时间,精确到小时，24小时格式 如 下午23:53 就是 23
     * 开区间 <
     * {@see LocalDateTime.now().getHour() }
     */
    private int endHour;

    /**
     * 对应广告位配置集合
     */
    private List<TicketPositionTimesLimit> ticketPositionTimesLimitList;

}
