package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * 券请求对象-中转信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/11/26 16:07
 */
public class TicketTransferRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;

    /**
     * 请求id
     */
    private String spm;
    /**
     * 用户ID,判断曝光次数等
     */
    private String uid;
    /**
     * 通过规则从imei/imeiMd5/androidId/androidIdMd5/oaid/idfa/idfaMd5中，获得该值
     */
    private String devUid;
    /**
     * imei
     */
    private String imei;
    /**
     * imei md5
     */
    private String imeiMd5;
    /**
     * 安卓id
     */
    private String anid;
    /**
     * 安卓id md5
     */
    private String anidMd5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * idfa
     */
    private String idfa;
    /**
     * idfa md5
     */
    private String idfaMd5;
    /**
     * imei/imeiMd5/androidId/androidIdMd5/oaid/idfa/idfaMd5的加密值
     */
    private String did;
    /**
     * 用户IP地址
     */
    private String ip;
    /**
     * User-Agent
     */
    private String ua;
    /**
     * MAC地址
     */
    private String mac;
    /**
     * 平台
     * @see Platform
     */
    private int platform = Platform.MOBILE;
    /**
     * 用户设备操作系统
     * @see Os
     */
    private int os = Os.UNKNOWN;
    /**
     * 系统版本号，如：10.0.0
     */
    private String osv;
    /**
     * 应用
     * @see App
     */
    private int app = App.UNKNOWN;
    /**
     * 广告位
     */
    private String position;
    /**
     * SSP广告位ID
     */
    private String sspPositionId;
    /**
     * SSP广告位场景
     */
    private Integer sspPositionScene;

    public String getSpm() {
        return spm;
    }

    public void setSpm(String spm) {
        this.spm = spm;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getDevUid() {
        return devUid;
    }

    public void setDevUid(String devUid) {
        this.devUid = devUid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getImeiMd5() {
        return imeiMd5;
    }

    public void setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
    }

    public String getAnid() {
        return anid;
    }

    public void setAnid(String anid) {
        this.anid = anid;
    }

    public String getAnidMd5() {
        return anidMd5;
    }

    public void setAnidMd5(String anidMd5) {
        this.anidMd5 = anidMd5;
    }

    public String getOaid() {
        return oaid;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getIdfaMd5() {
        return idfaMd5;
    }

    public void setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public int getPlatform() {
        return platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public int getOs() {
        return os;
    }

    public void setOs(int os) {
        this.os = os;
    }

    public String getOsv() {
        return osv;
    }

    public void setOsv(String osv) {
        this.osv = osv;
    }

    public int getApp() {
        return app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getSspPositionId() {
        return sspPositionId;
    }

    public void setSspPositionId(String sspPositionId) {
        this.sspPositionId = sspPositionId;
    }

    public Integer getSspPositionScene() {
        return sspPositionScene;
    }

    public void setSspPositionScene(Integer sspPositionScene) {
        this.sspPositionScene = sspPositionScene;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
